/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnexe.command.tag;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmTagParameters;
import org.apache.maven.scm.command.tag.AbstractTagCommand;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.SvnCommandUtils;
import org.apache.maven.scm.provider.svn.SvnTagBranchUtils;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnexe.command.SvnCommandLineUtils;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class SvnTagCommand
extends AbstractTagCommand
implements SvnCommand {
    public ScmResult executeTagCommand(ScmProviderRepository repo, ScmFileSet fileSet, String tag, String message) throws ScmException {
        ScmTagParameters scmTagParameters = new ScmTagParameters(message);
        scmTagParameters.setRemoteTagging(false);
        scmTagParameters.setPinExternals(false);
        return this.executeTagCommand(repo, fileSet, tag, scmTagParameters);
    }

    public ScmResult executeTagCommand(ScmProviderRepository repo, ScmFileSet fileSet, String tag, ScmTagParameters scmTagParameters) throws ScmException {
        int exitCode;
        if (scmTagParameters == null) {
            this.logger.debug("SvnTagCommand :: scmTagParameters is null create an empty one");
            scmTagParameters = new ScmTagParameters();
            scmTagParameters.setRemoteTagging(false);
            scmTagParameters.setPinExternals(false);
        } else {
            this.logger.debug("SvnTagCommand :: scmTagParameters.remoteTagging : " + scmTagParameters.isRemoteTagging());
        }
        if (tag == null || tag.trim().isEmpty()) {
            throw new ScmException("tag must be specified");
        }
        if (!fileSet.getFileList().isEmpty()) {
            throw new ScmException("This provider doesn't support tagging subsets of a directory");
        }
        SvnScmProviderRepository repository = (SvnScmProviderRepository)repo;
        File messageFile = FileUtils.createTempFile((String)"maven-scm-", (String)".commit", null);
        try {
            FileUtils.fileWrite((String)messageFile.getAbsolutePath(), (String)"UTF-8", (String)scmTagParameters.getMessage());
        }
        catch (IOException ex) {
            return new TagScmResult(null, "Error while making a temporary file for the commit message: " + ex.getMessage(), null, false);
        }
        Commandline cl = SvnTagCommand.createCommandLine(repository, fileSet.getBasedir(), tag, messageFile, scmTagParameters);
        CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Executing: " + SvnCommandLineUtils.cryptPassword(cl));
            if (Os.isFamily((String)"windows")) {
                this.logger.info("Working directory: " + cl.getWorkingDirectory().getAbsolutePath());
            }
        }
        try {
            exitCode = SvnCommandLineUtils.execute(cl, stdout, stderr);
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing command.", (Throwable)ex);
        }
        finally {
            try {
                FileUtils.forceDelete((File)messageFile);
            }
            catch (IOException iOException) {}
        }
        if (exitCode != 0) {
            return new TagScmResult(cl.toString(), "The svn tag command failed.", stderr.getOutput(), false);
        }
        ArrayList<ScmFile> fileList = new ArrayList<ScmFile>();
        List files = null;
        try {
            files = StringUtils.isNotEmpty((CharSequence)fileSet.getExcludes()) ? FileUtils.getFiles((File)fileSet.getBasedir(), (String)(StringUtils.isEmpty((CharSequence)fileSet.getIncludes()) ? "**" : fileSet.getIncludes()), (String)(fileSet.getExcludes() + ",**/.svn/**"), (boolean)false) : FileUtils.getFiles((File)fileSet.getBasedir(), (String)(StringUtils.isEmpty((CharSequence)fileSet.getIncludes()) ? "**" : fileSet.getIncludes()), (String)"**/.svn/**", (boolean)false);
        }
        catch (IOException e) {
            throw new ScmException("Error while executing command.", (Throwable)e);
        }
        for (File f : files) {
            fileList.add(new ScmFile(f.getPath(), ScmFileStatus.TAGGED));
        }
        return new TagScmResult(cl.toString(), fileList);
    }

    public static Commandline createCommandLine(SvnScmProviderRepository repository, File workingDirectory, String tag, File messageFile) {
        Commandline cl = SvnCommandLineUtils.getBaseSvnCommandLine(workingDirectory, repository);
        cl.createArg().setValue("copy");
        cl.createArg().setValue("--parents");
        cl.createArg().setValue("--file");
        cl.createArg().setValue(messageFile.getAbsolutePath());
        cl.createArg().setValue(".");
        String tagUrl = SvnTagBranchUtils.resolveTagUrl((SvnScmProviderRepository)repository, (ScmTag)new ScmTag(tag));
        tagUrl = SvnCommandUtils.fixUrl((String)tagUrl, (String)repository.getUser());
        cl.createArg().setValue(tagUrl + "@");
        return cl;
    }

    public static Commandline createCommandLine(SvnScmProviderRepository repository, File workingDirectory, String tag, File messageFile, ScmTagParameters scmTagParameters) {
        Commandline cl = SvnCommandLineUtils.getBaseSvnCommandLine(workingDirectory, repository);
        cl.createArg().setValue("copy");
        cl.createArg().setValue("--file");
        cl.createArg().setValue(messageFile.getAbsolutePath());
        cl.createArg().setValue("--encoding");
        cl.createArg().setValue("UTF-8");
        cl.createArg().setValue("--parents");
        if (scmTagParameters != null && scmTagParameters.getScmRevision() != null) {
            cl.createArg().setValue("--revision");
            cl.createArg().setValue(scmTagParameters.getScmRevision());
        }
        if (scmTagParameters != null && scmTagParameters.isPinExternals()) {
            cl.createArg().setValue("--pin-externals");
        }
        if (scmTagParameters != null && scmTagParameters.isRemoteTagging()) {
            String url = SvnCommandUtils.fixUrl((String)repository.getUrl(), (String)repository.getUser());
            cl.createArg().setValue(url + "@");
        } else {
            cl.createArg().setValue(".");
        }
        String tagUrl = SvnTagBranchUtils.resolveTagUrl((SvnScmProviderRepository)repository, (ScmTag)new ScmTag(tag));
        tagUrl = SvnCommandUtils.fixUrl((String)tagUrl, (String)repository.getUser());
        cl.createArg().setValue(tagUrl + "@");
        return cl;
    }
}

