/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.builtin;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;

public final class LongArrayCodec {
    private LongArrayCodec() {
    }

    public static void encode(ClientMessage clientMessage, long[] array) {
        int itemCount = array.length;
        ClientMessage.Frame frame = new ClientMessage.Frame(new byte[itemCount * 8]);
        for (int i2 = 0; i2 < itemCount; ++i2) {
            FixedSizeTypesCodec.encodeLong(frame.content, i2 * 8, array[i2]);
        }
        clientMessage.add(frame);
    }

    public static long[] decode(ClientMessage.Frame frame) {
        int itemCount = frame.content.length / 8;
        long[] result = new long[itemCount];
        for (int i2 = 0; i2 < itemCount; ++i2) {
            result[i2] = FixedSizeTypesCodec.decodeLong(frame.content, i2 * 8);
        }
        return result;
    }

    public static long[] decode(ClientMessage.ForwardFrameIterator iterator) {
        return LongArrayCodec.decode(iterator.next());
    }
}

