/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.proxy;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.PNCounterAddCodec;
import com.hazelcast.client.impl.protocol.codec.PNCounterGetCodec;
import com.hazelcast.client.impl.protocol.codec.PNCounterGetConfiguredReplicaCountCodec;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.client.impl.spi.ClientProxy;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.impl.VectorClock;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.crdt.pncounter.PNCounter;
import com.hazelcast.internal.util.ThreadLocalRandomProvider;
import com.hazelcast.logging.ILogger;
import com.hazelcast.partition.NoDataMemberInClusterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class ClientPNCounterProxy
extends ClientProxy
implements PNCounter {
    private static final AtomicReferenceFieldUpdater<ClientPNCounterProxy, VectorClock> OBSERVED_TIMESTAMPS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ClientPNCounterProxy.class, VectorClock.class, "observedClock");
    private static final List<Member> EMPTY_ADDRESS_LIST = Collections.emptyList();
    private final ILogger logger;
    private volatile Member currentTargetReplicaAddress;
    private final Object targetSelectionMutex = new Object();
    private volatile int maxConfiguredReplicaCount;
    private volatile VectorClock observedClock;

    public ClientPNCounterProxy(String serviceName, String objectName, ClientContext context) {
        super(serviceName, objectName, context);
        this.logger = this.getContext().getLoggingService().getLogger(ClientPNCounterProxy.class);
        this.observedClock = new VectorClock();
    }

    public String toString() {
        return "PNCounter{name='" + this.name + "'}";
    }

    @Override
    public long get() {
        Member target = this.getCRDTOperationTarget(EMPTY_ADDRESS_LIST);
        if (target == null) {
            throw new NoDataMemberInClusterException("Cannot invoke operations on a CRDT because the cluster does not contain any data members");
        }
        ClientMessage response = this.invokeGetInternal(EMPTY_ADDRESS_LIST, null, target);
        PNCounterGetCodec.ResponseParameters resultParameters = PNCounterGetCodec.decodeResponse(response);
        this.updateObservedReplicaTimestamps(resultParameters.replicaTimestamps);
        return resultParameters.value;
    }

    @Override
    public long getAndAdd(long delta) {
        Member target = this.getCRDTOperationTarget(EMPTY_ADDRESS_LIST);
        if (target == null) {
            throw new NoDataMemberInClusterException("Cannot invoke operations on a CRDT because the cluster does not contain any data members");
        }
        ClientMessage response = this.invokeAddInternal(delta, true, EMPTY_ADDRESS_LIST, null, target);
        PNCounterAddCodec.ResponseParameters resultParameters = PNCounterAddCodec.decodeResponse(response);
        this.updateObservedReplicaTimestamps(resultParameters.replicaTimestamps);
        return resultParameters.value;
    }

    @Override
    public long addAndGet(long delta) {
        Member target = this.getCRDTOperationTarget(EMPTY_ADDRESS_LIST);
        if (target == null) {
            throw new NoDataMemberInClusterException("Cannot invoke operations on a CRDT because the cluster does not contain any data members");
        }
        ClientMessage response = this.invokeAddInternal(delta, false, EMPTY_ADDRESS_LIST, null, target);
        PNCounterAddCodec.ResponseParameters resultParameters = PNCounterAddCodec.decodeResponse(response);
        this.updateObservedReplicaTimestamps(resultParameters.replicaTimestamps);
        return resultParameters.value;
    }

    @Override
    public long getAndSubtract(long delta) {
        Member target = this.getCRDTOperationTarget(EMPTY_ADDRESS_LIST);
        if (target == null) {
            throw new NoDataMemberInClusterException("Cannot invoke operations on a CRDT because the cluster does not contain any data members");
        }
        ClientMessage response = this.invokeAddInternal(-delta, true, EMPTY_ADDRESS_LIST, null, target);
        PNCounterAddCodec.ResponseParameters resultParameters = PNCounterAddCodec.decodeResponse(response);
        this.updateObservedReplicaTimestamps(resultParameters.replicaTimestamps);
        return resultParameters.value;
    }

    @Override
    public long subtractAndGet(long delta) {
        Member target = this.getCRDTOperationTarget(EMPTY_ADDRESS_LIST);
        if (target == null) {
            throw new NoDataMemberInClusterException("Cannot invoke operations on a CRDT because the cluster does not contain any data members");
        }
        ClientMessage response = this.invokeAddInternal(-delta, false, EMPTY_ADDRESS_LIST, null, target);
        PNCounterAddCodec.ResponseParameters resultParameters = PNCounterAddCodec.decodeResponse(response);
        this.updateObservedReplicaTimestamps(resultParameters.replicaTimestamps);
        return resultParameters.value;
    }

    @Override
    public long decrementAndGet() {
        Member target = this.getCRDTOperationTarget(EMPTY_ADDRESS_LIST);
        if (target == null) {
            throw new NoDataMemberInClusterException("Cannot invoke operations on a CRDT because the cluster does not contain any data members");
        }
        ClientMessage response = this.invokeAddInternal(-1L, false, EMPTY_ADDRESS_LIST, null, target);
        PNCounterAddCodec.ResponseParameters resultParameters = PNCounterAddCodec.decodeResponse(response);
        this.updateObservedReplicaTimestamps(resultParameters.replicaTimestamps);
        return resultParameters.value;
    }

    @Override
    public long incrementAndGet() {
        Member target = this.getCRDTOperationTarget(EMPTY_ADDRESS_LIST);
        if (target == null) {
            throw new NoDataMemberInClusterException("Cannot invoke operations on a CRDT because the cluster does not contain any data members");
        }
        ClientMessage response = this.invokeAddInternal(1L, false, EMPTY_ADDRESS_LIST, null, target);
        PNCounterAddCodec.ResponseParameters resultParameters = PNCounterAddCodec.decodeResponse(response);
        this.updateObservedReplicaTimestamps(resultParameters.replicaTimestamps);
        return resultParameters.value;
    }

    @Override
    public long getAndDecrement() {
        Member target = this.getCRDTOperationTarget(EMPTY_ADDRESS_LIST);
        if (target == null) {
            throw new NoDataMemberInClusterException("Cannot invoke operations on a CRDT because the cluster does not contain any data members");
        }
        ClientMessage response = this.invokeAddInternal(-1L, true, EMPTY_ADDRESS_LIST, null, target);
        PNCounterAddCodec.ResponseParameters resultParameters = PNCounterAddCodec.decodeResponse(response);
        this.updateObservedReplicaTimestamps(resultParameters.replicaTimestamps);
        return resultParameters.value;
    }

    @Override
    public long getAndIncrement() {
        Member target = this.getCRDTOperationTarget(EMPTY_ADDRESS_LIST);
        if (target == null) {
            throw new NoDataMemberInClusterException("Cannot invoke operations on a CRDT because the cluster does not contain any data members");
        }
        ClientMessage response = this.invokeAddInternal(1L, true, EMPTY_ADDRESS_LIST, null, target);
        PNCounterAddCodec.ResponseParameters resultParameters = PNCounterAddCodec.decodeResponse(response);
        this.updateObservedReplicaTimestamps(resultParameters.replicaTimestamps);
        return resultParameters.value;
    }

    @Override
    public void reset() {
        this.observedClock = new VectorClock();
    }

    private VectorClock toVectorClock(List<Map.Entry<UUID, Long>> replicaLogicalTimestamps) {
        VectorClock timestamps = new VectorClock();
        for (Map.Entry<UUID, Long> replicaTimestamp : replicaLogicalTimestamps) {
            timestamps.setReplicaTimestamp(replicaTimestamp.getKey(), replicaTimestamp.getValue());
        }
        return timestamps;
    }

    private ClientMessage invokeAddInternal(long delta, boolean getBeforeUpdate, List<Member> excludedAddresses, HazelcastException lastException, Member target) {
        if (target == null) {
            throw lastException != null ? lastException : new NoDataMemberInClusterException("Cannot invoke operations on a CRDT because the cluster does not contain any data members");
        }
        try {
            ClientMessage request = PNCounterAddCodec.encodeRequest(this.name, delta, getBeforeUpdate, this.observedClock.entrySet(), target.getUuid());
            return (ClientMessage)this.invokeOnMember(request, target.getUuid());
        }
        catch (HazelcastException e) {
            this.logger.fine("Unable to provide session guarantees when sending operations to " + target + ", choosing different target");
            if (excludedAddresses == EMPTY_ADDRESS_LIST) {
                excludedAddresses = new ArrayList<Member>();
            }
            excludedAddresses.add(target);
            Member newTarget = this.getCRDTOperationTarget(excludedAddresses);
            return this.invokeAddInternal(delta, getBeforeUpdate, excludedAddresses, e, newTarget);
        }
    }

    private ClientMessage invokeGetInternal(List<Member> excludedAddresses, HazelcastException lastException, Member target) {
        if (target == null) {
            throw lastException != null ? lastException : new NoDataMemberInClusterException("Cannot invoke operations on a CRDT because the cluster does not contain any data members");
        }
        try {
            ClientMessage request = PNCounterGetCodec.encodeRequest(this.name, this.observedClock.entrySet(), target.getUuid());
            return (ClientMessage)this.invokeOnMember(request, target.getUuid());
        }
        catch (HazelcastException e) {
            this.logger.fine("Exception occurred while invoking operation on target " + target + ", choosing different target", e);
            if (excludedAddresses == EMPTY_ADDRESS_LIST) {
                excludedAddresses = new ArrayList<Member>();
            }
            excludedAddresses.add(target);
            Member newTarget = this.getCRDTOperationTarget(excludedAddresses);
            return this.invokeGetInternal(excludedAddresses, e, newTarget);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Member getCRDTOperationTarget(Collection<Member> excludedAddresses) {
        if (this.currentTargetReplicaAddress != null && !excludedAddresses.contains(this.currentTargetReplicaAddress)) {
            return this.currentTargetReplicaAddress;
        }
        Object object = this.targetSelectionMutex;
        synchronized (object) {
            if (this.currentTargetReplicaAddress == null || excludedAddresses.contains(this.currentTargetReplicaAddress)) {
                this.currentTargetReplicaAddress = this.chooseTargetReplica(excludedAddresses);
            }
        }
        return this.currentTargetReplicaAddress;
    }

    private Member chooseTargetReplica(Collection<Member> excludedAddresses) {
        List<Member> replicaAddresses = this.getReplicaAddresses(excludedAddresses);
        if (replicaAddresses.isEmpty()) {
            return null;
        }
        int randomReplicaIndex = ThreadLocalRandomProvider.get().nextInt(replicaAddresses.size());
        return replicaAddresses.get(randomReplicaIndex);
    }

    private List<Member> getReplicaAddresses(Collection<Member> excludedAddresses) {
        Collection<Member> dataMembers = this.getContext().getClusterService().getMembers(MemberSelectors.DATA_MEMBER_SELECTOR);
        int maxConfiguredReplicaCount = this.getMaxConfiguredReplicaCount();
        int currentReplicaCount = Math.min(maxConfiguredReplicaCount, dataMembers.size());
        ArrayList<Member> replicaAddresses = new ArrayList<Member>(currentReplicaCount);
        Iterator<Member> dataMemberIterator = dataMembers.iterator();
        for (int i2 = 0; i2 < currentReplicaCount; ++i2) {
            Member dataMemberAddress = dataMemberIterator.next();
            if (excludedAddresses.contains(dataMemberAddress)) continue;
            replicaAddresses.add(dataMemberAddress);
        }
        return replicaAddresses;
    }

    private int getMaxConfiguredReplicaCount() {
        if (this.maxConfiguredReplicaCount > 0) {
            return this.maxConfiguredReplicaCount;
        }
        ClientMessage request = PNCounterGetConfiguredReplicaCountCodec.encodeRequest(this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        this.maxConfiguredReplicaCount = PNCounterGetConfiguredReplicaCountCodec.decodeResponse(response);
        return this.maxConfiguredReplicaCount;
    }

    private void updateObservedReplicaTimestamps(List<Map.Entry<UUID, Long>> receivedLogicalTimestamps) {
        VectorClock currentClock;
        VectorClock received = this.toVectorClock(receivedLogicalTimestamps);
        while (!(currentClock = this.observedClock).isAfter(received) && !OBSERVED_TIMESTAMPS_UPDATER.compareAndSet(this, currentClock, received)) {
        }
    }

    public Member getCurrentTargetReplica() {
        return this.currentTargetReplicaAddress;
    }
}

