/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline.test.impl;

import com.hazelcast.function.BiConsumerEx;
import com.hazelcast.jet.core.JetDataSerializerHook;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.pipeline.SourceBuilder;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Iterator;

public class ItemsDistributedFillBufferFn<T>
implements BiConsumerEx<Processor.Context, SourceBuilder.SourceBuffer<T>>,
IdentifiedDataSerializable {
    private Iterable<? extends T> items;

    public ItemsDistributedFillBufferFn() {
    }

    public ItemsDistributedFillBufferFn(Iterable<? extends T> items) {
        this.items = items;
    }

    @Override
    public void acceptEx(Processor.Context ctx, SourceBuilder.SourceBuffer<T> buf) throws Exception {
        Iterator<T> iterator = this.items.iterator();
        int i2 = 0;
        while (iterator.hasNext()) {
            T item = iterator.next();
            if (i2 % ctx.totalParallelism() == ctx.globalProcessorIndex()) {
                buf.add(item);
            }
            ++i2;
        }
        buf.close();
    }

    @Override
    public int getFactoryId() {
        return JetDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 5;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.items);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.items = (Iterable)in.readObject();
    }
}

