/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.commandline;

import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.messagevortex.MessageVortexConfig;
import net.messagevortex.MessageVortexLogger;
import picocli.CommandLine;

@CommandLine.Command(description={"initialize or upgrade configuration files"}, name="initconfig", aliases={"icfg"}, mixinStandardHelpOptions=true)
public class CommandLineHandlerInit
implements Callable<Integer> {
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    @CommandLine.Option(names={"--filename", "-f"}, description={"filename of the config file"})
    String filename = "messageVortex.cfg";
    @CommandLine.Option(names={"--newname", "-n"}, description={"filename of the new config file"})
    String nfilename = null;

    @Override
    public Integer call() throws Exception {
        LOGGER.log(Level.INFO, "init called");
        LOGGER.log(Level.INFO, "reading " + this.filename);
        MessageVortexConfig.getDefault().load(this.filename);
        if (this.nfilename == null) {
            this.nfilename = this.filename;
        }
        LOGGER.log(Level.INFO, "writing new  " + this.nfilename);
        MessageVortexConfig.getDefault().store(this.nfilename);
        return 0;
    }
}

